import { Link, useLocation } from 'react-router-dom'
import { Bike } from 'lucide-react'
import { motion } from 'framer-motion'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app">
      <header className="header">
        <div className="container">
          <div className="header-content">
            <motion.div 
              className="logo"
              whileHover={{ scale: 1.05, rotate: -5 }}
              transition={{ type: "spring", stiffness: 400 }}
            >
              <Bike className="logo-icon" size={32} color="#22C55E" />
              <span className="logo-text">BikeRent</span>
            </motion.div>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои аренды
              </Link>
              <Link 
                to="/rent" 
                className={`nav-link ${location.pathname === '/rent' ? 'active' : ''}`}
              >
                Арендовать
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main">
        {children}
      </main>

      <footer className="footer">
        <div className="container">
          <div className="footer-content">
            <div className="footer-section">
              <div className="footer-logo">
                <Bike className="footer-logo-icon" size={28} color="#4ADE80" />
                <h2>BikeRent</h2>
              </div>
              <p className="footer-description">
                Аренда велосипедов для активного отдыха и комфортных поездок по городу
              </p>
            </div>
            <div className="footer-section">
              <h3 className="footer-title">Контакты</h3>
              <ul className="footer-links">
                <li>
                  <span>Телефон:</span>
                  <a href="tel:+79991234567">+7 (999) 123-45-67</a>
                </li>
                <li>
                  <span>Email:</span>
                  <a href="mailto:info@bikerent.ru">info@bikerent.ru</a>
                </li>
                <li>
                  <span>Адрес:</span>
                  <span>г. Москва, ул. Велосипедная, д. 1</span>
                </li>
              </ul>
            </div>
            <div className="footer-section">
              <h3 className="footer-title">Режим работы</h3>
              <ul className="footer-links">
                <li>Пн-Вс: 8:00 - 22:00</li>
                <li>Без выходных</li>
              </ul>
            </div>
          </div>
          <div className="footer-bottom">
            <p>&copy; 2025 BikeRent. Все права защищены.</p>
          </div>
        </div>
      </footer>
    </div>
  )
}

export default Layout

